function commLabels = getCommunitiesMMsig( obj,minQ,minZ,nIters)
%GETCOMMUNITIESMMSIG Get community structure of AdjacencyMatrix object,
%performing statistical test for significance, and recursively calling
%itself until no further divisions of community structures are
%statistically significant.  Called by getCommunitiesHMM
%
%   commLabels = GETCOMMUNITIESMMSIG(obj,minQ,nIters) returns a cell array of
%       community membership.  Items in this cell array may be themselves
%       cell arrays, depending on the depth of the community hierarchy of
%       obj.  This gives the hierarchical structure of the sub-communities.

nSwitches = 10;
% Get the community structure of obj
[commLabels Q] = getCommunitiesMM(obj,'quiet');

%If no subcommunities are found, simply return obj
if numel(commLabels) == 1
    return
end
%If Q is too small (< minQ), simply return object - this indicates no
%significant community structure
if Q<minQ 
    return
end

% Otherwise test its statistical significance

% Qs stores the modularities for the random graphs
Qs = zeros(1,nIters);

for i = 1:nIters
    A = randmio_dir_connected(getSquareMatrix(obj),nSwitches);
    [Ci Qs(i)] = modularity_dir(full(A));
end

meanQs = mean(Qs);
sigQs = std(Qs);
z = (Q-meanQs)/sigQs;

% Plot distribution of modularities
% figure;
% hist(Qs,15);

% If statistically significant, perform further subdivision
if (z > minZ)
    for i = 1:numel(commLabels)
        if numel(commLabels{i})>1
            commLabels{i} = getCommunitiesMMsig(getSubMatrix(obj,commLabels{i}),minQ,minZ,nIters);
        end
    end
end

    
end

